


#include "lib_sn.h"
#include "c4d_string.h"
#include "c4d_gui.h"


SNLib *lib_sn = NULL;


static SNLib *CheckPrefsLib(LONG offset)
{
	return (SNLib*)CheckLib(LIBRARY_SN,offset,(C4DLibrary**)&lib_sn);
}


Bool SN_Register(LONG id,SNHook *snhook)
{
	SNLib *lib = CheckPrefsLib(LIBOFFSET(SNLib,SN_Register));
	if (!lib || !lib->SN_Register) return FALSE;
	return (*lib->SN_Register)(id,snhook);
}

SNHook *SN_FindHook(LONG id)
{
	SNLib *lib = CheckPrefsLib(LIBOFFSET(SNLib,SN_FindHook));
	if (!lib || !lib->SN_FindHook) return NULL;
	return (*lib->SN_FindHook)(id);
}



LONG iSN_Check(SNHook *snhook,const String &c4dsn,const String &sn,LONG regdate,LONG curdate)
{
	if (!snhook) return NULL;
	return ((SNHookClass*)(snhook->thisptr))->SNCheck(c4dsn,sn,regdate,curdate);
}

const String& iSN_GetTitle(SNHook *snhook)
{
	if (!snhook) return *C4DOS.St->Default;
	return ((SNHookClass*)(snhook->thisptr))->GetTitle();
}


SNHookClass::SNHookClass()
{
	hook.thisptr			= this;
	hook.SN_Check			= iSN_Check;
	hook.SN_GetTitle	= iSN_GetTitle;
}

Bool SNHookClass::Register(LONG id,LONG flags)
{
	hook.flags = flags;
	return SN_Register(id,&hook);
}

LONG SNHookClass::SNCheck(const String &c4dsn,const String &sn,LONG regdate,LONG curdate)
{
	return SN_WRONGNUMBER;
}

const String& SNHookClass::GetTitle()
{
	return *C4DOS.St->Default;
}
